Attribute VB_Name = "mdAddComponent"
'	This is a part of the source code for Pro/DESKTOP.
'	Copyright (C) 1999 Parametric Technology Corporation.
'	All rights reserved.


Function AddComponent(pathname As String)
'Convenience Function to add an Assembly Component

'Get the ProDESKTOP Application object
GetApplicationObject

'Get the active part document
Dim Part As PartDocument
Set Part = app.GetActiveDoc

'Open the file
Dim component As aDesign
Set component = Part.OpenDesign(pathname)
If component Is Nothing Then
    Exit Function
End If

If (component Is Part.GetDesign()) Then
    MsgBox ("You cannot add the active design as a component of itself")
    Exit Function
End If

'Get Active workplane
Dim workplane As aWorkplane
Set workplane = Part.GetActiveWorkplane

'Set the transformation matrix
Dim translation As zMatrix
Dim temp1 As zMatrix
Dim temp2 As zMatrix
Set temp1 = app.GetClass("Matrix").CreateTranslationMatrix(workplane.GetLocalOrigin)
Set temp2 = app.GetClass("Matrix").CreateRotationMatrix(workplane.GetLocalX, workplane.GetLocalY)
Set translation = temp1.MultiplyByMatrix(temp2)

'Create the component in the proper workplane
Dim workplaneSet As ObjectSet
Set workplaneSet = component.GetWorkplanes
count = workplaneSet.GetCount

Dim workplaneSetIt As Iterator
Dim currentWorkplane As aWorkplane
Set workplaneSetIt = app.GetClass("It").CreateAObjectIt(workplaneSet)

Dim str As String
Set currentWorkplane = workplaneSetIt.start
For I = 0 To count - 1
    str = currentWorkplane.GetName
    If str = "base" Then
        Set temp3 = app.GetClass("Matrix").CreateTranslationMatrix(currentWorkplane.GetLocalOrigin)
        Set temp4 = app.GetClass("Matrix").CreateRotationMatrix(currentWorkplane.GetLocalX, currentWorkplane.GetLocalY)
        Set oldMapping = temp3.MultiplyByMatrix(temp4)
        Set translation = translation.MultiplyByMatrix(oldMapping.GetInverse)
        Exit For
    End If
Set currentWorkplane = workplaneSetIt.Next
Next I

'Add the Component
Set AddComponent = Part.GetDesign.CreateComponent(component, translation)
    
End Function






